<?= $this-> include('templates/header');?>
<main id="nsofts_main">
    <div class="nsofts-container">
        <div class="card h-100">
            <div class="card-top d-md-inline-flex align-items-center justify-content-between py-3 px-4">
                <div class="d-inline-flex align-items-center text-decoration-none fw-semibold">
                    <span class="ps-2 lh-1"><?= isset($pageTitle) ? esc($pageTitle) : "" ?></span>
                </div>
                <div class="d-flex mt-2 mt-md-0">
                    <form method="get" id="searchForm" action="" class="me-2">
                        <div class="input-group">
                            <input type="text" id="search_input" class="form-control" placeholder="Search here..." name="keyword" value="<?= isset($_GET['keyword']) ? esc($_GET['keyword']) : '' ?>" required="required">
                            <button class="btn btn-outline-default d-inline-flex align-items-center" type="search">
                                <i class="ri-search-2-line"></i>
                            </button>
                        </div>
                    </form>
                    <a href="<?= base_url('ns-admin/create-countries') ?>" class="btn btn-primary d-inline-flex align-items-center justify-content-center">
                        <i class="ri-add-line"></i>
                        <span class="ps-1 text-nowrap d-none d-sm-block">Create Countries</span>
                    </a>
                </div>
            </div>
            <div class="card-body p-4">
                <?php if(!empty($result)){ ?>
                    <div class="row g-4" id="load-more-container">
                        <?php $i=0; foreach($result as $row){ ?>
                            <div class="col-lg-3 col-sm-6 card-item">
                                <div class="nsofts-image-card">
                                    <div class="nsofts-image-card__cover">
                                        <div class="nsofts-switch d-flex align-items-center enable_disable" data-bs-toggle="tooltip" data-bs-placement="top" title="Enable / Disable">
                                            <input type="checkbox" id="enable_disable_check_<?= $i ?>" data-id="<?= $row['sid'] ?>" data-action="<?= base_url('ns-admin/status-category/'.$row['sid']) ?>" data-column="status" class="cbx hidden btn_enable_disable" <?php if ($row['status'] == 1) { echo 'checked'; } ?>>
                                            <label for="enable_disable_check_<?= $i ?>" class="nsofts-switch__label"></label>
                                        </div>
                                        <img src="<?= base_url('images/'.$row['countries_image']) ?>" onerror="this.src='<?= base_url('assets/images/300x300.jpg') ?>';"  loading="lazy"  alt="<?= isset($row['countries_name']) ? esc($row['countries_name']) : '' ?>">
                                    </div>
                                    <div class="nsofts-image-card__content nsofts-bottom">
                                        <div class="position-relative">
                                            <div class="d-flex align-items-center justify-content-between nsofts-image-card__content__text">
                                                <span class="d-block text-truncate fs-6 fw-semibold pe-2"><?= isset($row['countries_name']) ? esc($row['countries_name']) : '' ?></span>
                                                <div class="nsofts-image-card__option d-flex">
                                                    <a href="<?= base_url('ns-admin/create-countries/'.$row['sid']) ?>" class="btn border-0" data-bs-toggle="tooltip" data-bs-placement="top" title="Edit">
                                                        <i class="ri-pencil-fill"></i>
                                                    </a>
                                                    <a href="javascript:void(0)" class="btn border-0 text-danger btn_delete" data-action="<?= base_url('ns-admin/delete-countries/'.$row['sid']) ?>" data-bs-toggle="tooltip" data-bs-placement="top" title="Delete"><i class="ri-delete-bin-fill"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php $i++; } ?>
                    </div>
                    <button class="nsofts-load-btn mt-4 mb-2 d-flex align-items-center justify-content-center"
                        id="load-more-btn">
                        <span>Load More</span>
                        <i class="ri-sort-desc"></i>
                    </button>
                <?php } else { ?>
                    <h3 class="text-center p-5">No data found</h3>
                <?php } ?>
                </nav>
            </div>
        </div>
    </div>
</main>
<?= $this-> include('templates/footer');?>